<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Laporan_model extends CI_Model {

	public function get_toko() {
	    $kdtoko = $this->session->userdata('kd_toko');
		$query = $this->db->query("SELECT * FROM tabel_toko where kd_toko='$kdtoko'");
		return $query->row();
	}
	public function get_tokoku($kdtoko) {
		$user = $this->session->userdata('kd_toko');
		$query = $this->db->query("SELECT * FROM tabel_toko where kd_toko='$kdtoko';");
		return $query->row();
	}

	public function getDataRetur($tanggal) {
		$this->db->where('tgl', $tanggal);
		return $this->db->get('tabel_retur');
	}

	public function getDataReturFilter($tgl_awal, $tgl_akhir) {
		$this->db->where('tgl BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"');
		return $this->db->get('tabel_retur');
	}

	public function getDataPengeluaranRekap($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('*')
			->where('tgl BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('kdcabang', $kdtoko)
			->group_by('tgl')
			->get('tabel_biaya');
	}

	public function getDataPengeluaranRinci($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('*')
			->where('tgl BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('kdcabang', $kdtoko)
			->get('tabel_biaya');
	}

	public function getNilaiPersediaan() {
		return $this->db->select('a.kd_barang,a.nm_barang,a.hrg_jual,a.hrg_beli,b.stok,a.modal_per_porsi')
			->join('tabel_stok_toko AS b', 'a.kd_barang = b.kd_barang', 'LEFT')
			->where('b.stok > 0')
			->order_by('a.kd_barang')
			->get('tabel_barang AS a');
	}

	public function getDataPembelian($tanggal) {
		return $this->db->select('a.no_faktur_pembelian,a.tgl_pembelian,b.kd_barang,b.nm_barang,b.satuan,b.jumlah,b.harga,b.sub_total_beli')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian', $tanggal)
			->where('a.selesai', '1')
			->order_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}

	public function getDataPembelianFilter($tgl_awal, $tgl_akhir) {
		return $this->db->select('a.no_faktur_pembelian,a.tgl_pembelian,b.kd_barang,b.nm_barang,b.satuan,b.jumlah,b.harga,b.sub_total_beli')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('a.selesai', '1')
			->get('tabel_pembelian AS a');
	}

	public function getDataPenjualanTransaksiFilter($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->group_by('a.no_faktur_penjualan')
			->get('tabel_penjualan AS a');
	}
	public function getDatamutasiTransaksiFilter($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '4')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}

	public function getDataproduksiTransaksiFilter($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '5')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}
	public function getDatapromoTransaksiFilter($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
	    $kdakses=$this->session->userdata('akses');
	    if($kdakses =='kasir') {
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '3')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	    }
	    if($kdakses !='kasir') {
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.jtran', '3')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	    }
	}

	public function getDatakeluarTransaksiFilter($tgl_awal, $tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '6')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}

	public function getDataPenjualanTransaksi($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->group_by('a.no_faktur_penjualan')
			->get('tabel_penjualan AS a');
	}
	public function getDatabroadcast($bulan,$tahun) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('id,tgl,broadcast,if(stat="0","Simpan","Simpan Kirim") as stat,kduser')
			->where('month(tgl)', $bulan)
			->where('year(tgl)', $tahun)
			->get('tabel_promosi');
	}
	public function getDatabroadcastfilter($tgl_awal,$tgl_akhir) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('id,tgl,broadcast,if(stat="0","Simpan","Simpan Kirim") as stat,kduser')
			->where('tgl BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->get('tabel_promosi');
	}
	public function getDatamutasiTransaksi($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '4')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}
		public function getDataproduksiTransaksi($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '5')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}
		public function getDatapromoTransaksi($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '3')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}
		public function getDatakeluarTransaksi($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.*,b.*')
			->join('tabel_rinci_pembelian AS b', 'a.no_faktur_pembelian = b.no_faktur_pembelian')
			->where('a.tgl_pembelian', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_pembelian AS b WHERE a.no_faktur_pembelian=b.no_faktur_pembelian)')
			->where('a.kdcabang', $kdtoko)
			->where('a.jtran', '6')
			->group_by('a.no_faktur_pembelian')
			->get('tabel_pembelian AS a');
	}

	public function getDataPenjualanBarangFilter($tgl_awal, $tgl_akhir,$jual) {
	    $kdtoko = $this->session->userdata('kd_toko');
	     if ($jual=='s3') {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
		                        SUM(b.sub_total_jual) as brt_rp,
		                        SUM(b.nppn) as ppn_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tgl_akhir)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	    } 
	    if ($jual=='s1') {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
		                        SUM(b.sub_total_jual) as brt_rp,
		                        SUM(b.nppn) as ppn_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                               SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tgl_akhir)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->where('a.waktu <', '16:01:00')
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	    } 
	   if ($jual=='s2')  {
	       return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual) as brt_rp,
		                        SUM(b.nppn) as ppn_rp,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tgl_akhir)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->where('a.waktu >=', '16:01:00')
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	       
	   }
	    
	}
	
		public function getDataPenjualanBarangFilter1($tgl_awal, $tgl_akhir,$jual,$kdtoko) {
	     if ($jual=='s3') {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,c.nama_menu as nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
								SUM(b.sub_total_jual) as brt_rp,
								SUM(b.nppn) as ppn_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->join('tabel_menu as c','b.kd_barang=c.kode_menu','left')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	    } 
	    if ($jual=='s1') {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
								SUM(b.nppn) as ppn_rp,
								SUM(b.sub_total_jual) as brt_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->where('a.waktu <', '16:01:00')
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	    } 
	   if ($jual=='s2')  {
	       return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
								SUM(b.nppn) as ppn_rp,
								SUM(b.sub_total_jual) as brt_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->where('a.waktu >=', '16:01:00')
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	       
	   }
	    
	}
	

	public function getDataPenjualanBarang($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.nppn) as ppn_rp,
		                        SUM(b.sub_total_jual) as brt_rp,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                               SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                 SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->group_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	}
public function getDataPenjualanBarang1($tanggal,$kdtoko) {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,SUM(b.retur) AS jum_retur,
		                        SUM(b.jumlah) as jum_item,
		                        SUM(b.sub_total_jual+b.nppn) as jum_rp,
		                        SUM(IF(a.kdharga="KH02",b.jumlah,0)) AS gf,
		                        SUM(IF(a.kdharga="KH03",b.jumlah,0)) AS gr,
		                        SUM(IF(a.kdharga="KH04",b.jumlah,0)) AS sf,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",b.jumlah,0),0),0),0)) AS rg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",b.jumlah,0),0),0),0)) AS prex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",b.jumlah,0),0),0)) AS rd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",b.jumlah,0),0)) AS pr,
                                SUM(IF(a.kdharga="KH02",(b.sub_total_jual),0)) AS rgf,
                                SUM(IF(a.kdharga="KH03",(b.sub_total_jual),0)) AS rgr,
		                        SUM(IF(a.kdharga="KH04",(b.sub_total_jual),0)) AS rsf,
                                 SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang<>"JP1",(b.sub_total_jual),0),0),0),0)) AS rrg,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan<>"3",IF(a.promo="1",if(b.jnsbarang="JP1",(b.sub_total_jual),0),0),0),0)) AS rprex,
                                SUM(IF(a.kdharga="KH01",IF(a.layanan="3",IF(a.promo="1",(b.sub_total_jual),0),0),0)) AS rrd,
                                SUM(IF(a.kdharga="KH01",IF(a.promo="2",(b.sub_total_jual),0),0)) AS rpr
                                ')
                                
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->group_by('b.kd_barang')
			->order_by('b.jnsbarang')
			->order_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	}

	public function getDataProfit($tgl_awal, $tgl_akhir) {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,b.harga_modal,b.harga,b.retur AS jum_retur, b.jumlah AS jum_item')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->order_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	}

	public function getDiskonBarang($tgl_awal, $tgl_akhir) {
		return $this->db->select('SUM(b.diskonrp) AS disk1')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->get('tabel_penjualan AS a');
	}

	public function getDiskonAkhir($tgl_awal, $tgl_akhir) {
		return $this->db->select('SUM(diskon) AS diska')
			->where('a.tgl_penjualan BETWEEN "' . date('Y-m-d', strtotime($tgl_awal)) . '" and "' . date('Y-m-d', strtotime($tgl_akhir)) . '"')
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->get('tabel_penjualan AS a');
	}

	public function getDataProfit1($tanggal) {
		return $this->db->select('a.no_faktur_penjualan, b.kd_barang,b.nm_barang,b.harga_modal,b.harga,b.retur AS jum_retur, b.jumlah AS jum_item')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->order_by('b.kd_barang')
			->get('tabel_penjualan AS a');
	}

	public function getDiskonBarang1($tanggal) {
		return $this->db->select('SUM(b.diskonrp) AS disk1')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->get('tabel_penjualan AS a');
	}

	public function getDiskonAkhir1($tanggal) {
		return $this->db->select('SUM(diskon) AS diska')
			->where('a.tgl_penjualan', $tanggal)
			->where('EXISTS (SELECT 1 FROM tabel_rinci_penjualan AS b WHERE a.no_faktur_penjualan=b.no_faktur_penjualan)')
			->where('a.selesai', '1')
			->get('tabel_penjualan AS a');
	}

	public function getDataPengeluaranRinci1($tanggal) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('*')
			->where('tgl', $tanggal)
			->where('kdcabang', $kdtoko)
			->get('tabel_biaya');
	}

	public function getDataRekap($tahun, $bulan) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('a.tgl_penjualan, SUM(b.harga*b.jumlah) AS tot_jual, SUM(b.jumlah*b.harga_modal) AS tot_modal, SUM(b.diskonrp) AS tot_diskon1')
			->join('tabel_rinci_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan')
			->where('MONTH(a.tgl_penjualan)', $bulan)
			->where('YEAR(a.tgl_penjualan)', $tahun)
			->where('a.selesai', '1')
			->where('a.kdcabang', $kdtoko)
			->group_by('a.tgl_penjualan')
			->get('tabel_penjualan AS a');
	}

	public function getDiskon($tahun, $bulan) {
		return $this->db->select('SUM(diskon) AS tot_diskon2')
			->where('MONTH(a.tgl_penjualan)', $bulan)
			->where('YEAR(a.tgl_penjualan)', $tahun)
			->where('a.selesai', '1')
			->group_by('a.tgl_penjualan')
			->get('tabel_penjualan AS a');
	}

	public function getDataPengeluaranRekapitulasi($tahun, $bulan) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->select('*')
			->where('MONTH(tgl)', $bulan)
			->where('YEAR(tgl)', $tahun)
			->where('kdcabang', $kdtoko)
			->group_by('tgl')
			->get('tabel_biaya');
	}

}

/* End of file Laporan_model.php */
/* Location: ./application/models/Laporan_model.php */